/********************************************

Framework code for the Remote CPU

This code currently:
 serves as a combined header, library, and code file.
 The header and library will need to be branched off
 to separate documents at some point.
*********************************************/


/*********************************************
Notes:
  PortE reverts to a digital input on any device reset
  port numbering: 7654 3210
  set tris register HIGH (1) to make corressponding port INPUT
  LOW (0) for output
*********************************************/
#include <system.h> // necessary to use C functions
#include "AwesomeLIB.h" // necessary to use Awesome-O Functions
#include "buttons.h"
#include "serial1.h"
#include "a2d.h"
#include "lcd.h"

#pragma CLOCK_FREQ 20000000
#pragma DATA _CONFIG1H, 0b00000010  
#pragma DATA _CONFIG2H, 0   
#pragma DATA _CONFIG4L, 0b00000001   
#pragma DATA _CONFIG3H, 0b10000000  


void main(void)
{

	char state;
    delay_ms(300);
	spi_init(); // Initialze all values for Serial Port
	init_led();
	lcd_init();	
	init_buttons();
	a2d_init();
	intcon2.7 = 0;
	delay_us(100);
	a2d_calibrate();
	
	//Setup ZigBee
	setup_fcf();
	setup_pan(0xBB,0xBB);
	setup_addr(0xDD,0xDD);
	
	char switches;
	char buttons;
	char i;
	
	while(1)
	{
	lcd_clear();
	setup();
	switches = check_switches();
	if(switches == 1)
	{
		lcd_clear();
		lcd_printf("Enter Mode Here");
	
		while(switches == 1)
		{
			lcd_cmd(0x56);
			delay_ms(700);
			switches = check_switches();
		}
	}
	if(switches == 0)
	{
		lcd_clear();
		lcd_printf("Transmitting...");
		zigbee_init();
		delay_ms(5);
		transceiver_reset();  //Reset the hardware and send to state TRX_OFF
		delay_ms(5);
		transceiver_pll_on();  //Set to transmitter
		delay_ms(5);
		
		while(switches == 0)
		{
		setup_buttons();
		setup_joysticks();
		send_packet();
		delay_ms(80);
		switches = check_switches();
		} 
	}

	
	}                                                                                                                                                                                                                                                                                                                                                                    


}