#include <system.h>

#include "a2d.h"
#include "buttons.h"
#include "AwesomeLIB.h"
#include "lcd.h"


void a2d_init(void)
{
	trisa |= 0xFF;  // set portA to inputs
	adcon1 = 0x0b; 	// A0 - A3 analog, rest digital, 0b00001011
	adcon2 = 0x22; 	// TAD is 32*Tosc 1.6usec with TAQ = 2 TAD, 0b00100010
	adcon0.0 = 1;  	// enable a2d
	return;
} 

void a2d_calibrate(void)
{
	char switches = check_switches();

	if	(switches == 3)
			{ 
			lcd_clear();
			lcd_printf("Calibrating");
			lcd_cmd(0x56);
			delay_ms(1);
			lcd_cmd(0x56);
			delay_ms(1);
			a2d_find_neutral();
			while (switches == 3)
				{
				a2d_find_boundary();
				set_led(0b1111111111);
				display_led();
				switches = check_switches();
				}
			} 
}

char a2d_convert(char channel)
{
	if (channel==0){		// set channel
		adcon0.5 = 0;
		adcon0.4 = 0;
		adcon0.3 = 0;
		adcon0.2 = 0;}
	else if (channel==1){
		adcon0.5 = 0;
		adcon0.4 = 0;
		adcon0.3 = 0;
		adcon0.2 = 1;}
	else if (channel==2){
		adcon0.5 = 0;
		adcon0.4 = 0;
		adcon0.3 = 1;
		adcon0.2 = 0;}
	else if (channel==3){
		adcon0.5 = 0;
		adcon0.4 = 0;
		adcon0.3 = 1;
		adcon0.2 = 1;}


	char result;
	adcon0.1 = 1;  			// start conversion
	while(adcon0.1);  		// wait to finish
	result = adresh;
	return result;  			// return value (8 bits from high register)
}

void a2d_find_neutral(void)
{
	char i;
	for(i = 0; i < 4; ++i) 				// step through each potentiometer
	{
		neutral[i] = a2d_convert(i);	// set neutral
	}
	return;
}

void a2d_find_boundary(void)
{
	char i;
	signed char test;
	for(i = 0; i < 4; ++i) 		// step through each potentiometer
	{
		test = a2d_convert(i);   
		
		if(test > max[i]) 		// compare result to maximum
			{
			max[i] = test;  	// set new maximum limit
			}
		if(test < min[i]) 		// compare result to minimum
			{
			min[i] = test;  	// set new minimum limit
			}
	}
	return;
}


void a2d_convert_all(void)
{
	char i;
	for(i = 0; i < 4; ++i)			// step through each potentiometer
		raw[i] = a2d_convert(i);	// obtain raw a2d value
	return;
}


void a2d_scale_all(char jvalue[])
{
	char i;
	for(i = 0; i < 4; ++i) //++i		// step through each potentiometer
	{
		if(raw[i] < neutral[i])  		// see if less than neutral
		{
			jvalue[i] = ((raw[i]-min[i])*100 / (neutral[i]-min[i])) - 100;
			
			if(jvalue[i] < -100) 		// make sure scaled value is within boundaries
				jvalue[i] = -100;
		}
		else if(raw[i] > neutral[i])	// see if greater than neutral
		{
			jvalue[i] = (raw[i]-neutral[i])*100 / (max[i]-neutral[i]);
			
			if(jvalue[i] > 100) 		// make sure scaled value is within boundaries 
				jvalue[i] = 100;
		}
		else jvalue[i] = 0;				// if raw[i] = limits[i][1], it's at neutral position
	}
	return;
}

