#include <system.h>
#include "buttons.h"
#include "a2d.h"

unsigned short display_vals;  // used only in this file



void set_led(unsigned short data)
{
	display_vals = data;
	return;
}

void init_buttons(void)
{
	intcon2.7 = 0; //Enable Pullup Resistors

	//Set buttons to inputs

	trisb.1 = 1;
	trisb.2 = 1;
	trisb.3 = 1;
	trisb.4 = 1;
	trisb.5 = 1;
	trisb.6 = 1; 
	
	//Set Button Row to outputs
	trise.1 = 0;
	trise.0 = 0;
	return;
	
	//Set up Switches
	trisd.6 = 1;
	trisd.7 = 1;
}

char check_switches(void)
{
	char SWL;
	char SWR;
	SWL = portd.6;
	SWR = portd.7;
	SWR = SWR*2;
	char switches;
	switches = SWL + SWR;
	
	return switches;
}

#define BDELAY 150
char check_topbuttons(void)
{
	unsigned short BC6;
	unsigned short BC5;
	unsigned short BC4;
	unsigned short BC3;
	unsigned short BC2;
	unsigned short BC1;
	unsigned short buttonstate;
	intcon2.7 = 0;
	
		late.1 = 0;
		late.0 = 1;
	
	if (portb.0 == 0)
	{
		delay_us(150);
		if (portb.0 == 0)
		{
			BC6 = 1;
		}
		else
		{
			BC6 = 0;
		}
	}
	
	if (portb.1 == 0)
	{
		delay_us(150);
		if (portb.1 == 0)
		{
			BC5 = 1;
		}
		else
		{
			BC5 = 0;
		}
	}
	if (portb.2 == 0)
	{
		delay_us(150);
		if (portb.2 == 0)
		{
			BC4 = 1;
		}
		else
		{
			BC4 = 0;
		}
	}
	if (portb.3 == 0)
	{
		delay_us(150);
		if (portb.3 == 0)
		{
			BC3 = 1;
		}
		else
		{
			BC3 = 0;
		}
	}
	if (portb.4 == 0)
	{
		delay_us(150);
		if (portb.4 == 0)
		{
			BC2 = 1;
		}
		else
		{
			BC2 = 0;
		}
	}
	if (portb.5 == 0)
	{
		delay_us(150);
		if (portb.5 == 0)
		{
			BC1 = 1;
		}
		else
		{
			BC1 = 0;
		}
	}
	
	BC6 = BC6*32;
	BC5 = BC5*16;
	BC4 = BC4*8;
	BC3 = BC3*4;
	BC2 = BC2*2;
	
	
	
	buttonstate = BC1+BC2+BC3+BC4+BC5+BC6;

	return buttonstate;
}

char check_bottombuttons(void)
{
	unsigned short BC6;
	unsigned short BC5;
	unsigned short BC4;
	unsigned short BC3;
	unsigned short BC2;
	unsigned short BC1;
	unsigned short buttonstate;
	intcon2.7 = 0;
	
	late.1 = 1;
	late.0 = 0;
	
	if (portb.0 == 0)
	{
		delay_us(150);
		if (portb.0 == 0)
		{
			BC6 = 1;
		}
		else
		{
			BC6 = 0;
		}
	}
	
	if (portb.1 == 0)
	{
		delay_us(150);
		if (portb.1 == 0)
		{
			BC5 = 1;
		}
		else
		{
			BC5 = 0;
		}
	}
	if (portb.2 == 0)
	{
		delay_us(150);
		if (portb.2 == 0)
		{
			BC4 = 1;
		}
		else
		{
			BC4 = 0;
		}
	}
	if (portb.3 == 0)
	{
		delay_us(150);
		if (portb.3 == 0)
		{
			BC3 = 1;
		}
		else
		{
			BC3 = 0;
		}
	}
	if (portb.4 == 0)
	{
		delay_us(150);
		if (portb.4 == 0)
		{
			BC2 = 1;
		}
		else
		{
			BC2 = 0;
		}
	}
	if (portb.5 == 0)
	{
		delay_us(150);
		if (portb.5 == 0)
		{
			BC1 = 1;
		}
		else
		{
			BC1 = 0;
		}
	}
	
	BC6 = BC6*32;
	BC5 = BC5*16;
	BC4 = BC4*8;
	BC3 = BC3*4;
	BC2 = BC2*2;
	
	
	
	buttonstate = BC1+BC2+BC3+BC4+BC5+BC6;

	return buttonstate;
}


void init_led(void)
{
//Set LED's
trisd.1 = 0;
trisd.2 = 0;
trisd.3 = 0;
trisd.4 = 0;
trisd.5 = 0;

latd.1 = 1;
latd.2 = 1;
latd.3 = 1;
latd.4 = 1;
latd.5 = 1;

//Set LED Selects as outputs
trisa.4 = 0;
trisa.5 = 0;

//Start them as off
lata.4 = 0;
lata.5 = 0;

return;

}

void display_led(void)
{

	static bool low = true;
	if(low)
	{
		lata.5 = 1;  // turn off high
		LED4 = !((display_vals & 0x10) >> 4);
		LED3 = !((display_vals & 0x08) >> 3);
		LED2 = !((display_vals & 0x04) >> 2);
		LED1 = !((display_vals & 0x02) >> 1);
		LED0 = !(display_vals & 0x01);
		lata.4 = 0;  // turn on lows
		low = !low;
	}
	else
	{
		lata.4 = 1;  // turn off lows
		LED4 = !(((display_vals >> 5) & 0x10) >> 4);
		LED3 = !(((display_vals >> 5)  & 0x08) >> 3);
		LED2 = !(((display_vals >> 5)  & 0x04) >> 2);
		LED1 = !(((display_vals >> 5)  & 0x02) >> 1);
		LED0 = !((display_vals >> 5)  & 0x01);
		lata.5 = 0;  // turn on highs
		low = !low;
	}
	
	return;
}
