#include <system.h>
#include "AwesomeLIB.h"
#include "lcd.h"

void lcd_int(char data)
{
  char val;   // ascii results
  char temp;
  char div;
  char i;
  bool dozero;
  dozero = false;
  div = 100;
  if(data == 0)  // always print 0
  {
    lcd_char('0');
    return;
  }
    /*
     * adjust for sign
     * */
  if(data & 10000000b)
  {
    lcd_char('-');
    data = ~data + 1;
  }
  for(i=0; i <= 2; ++i)   // get all 3 digits
  {
    val = data/div;       // get most signif. digit
    if(val != 0 || dozero)
    { 
      lcd_char(val + '0');    // print digit
      delay_us(100);
      dozero = true;
    }
    temp = val * div;   // subtract off
    data = data - temp;   // what we’ve printed
    div=div/10;         // adjust divisor
  }
  return;
}

void lcd_dec(char data)
{
  lcd_char(((data /100) & 255) + 0x30);
  delay_us(10);
  data = data % 100;
  lcd_char( ((data / 10) & 255) + 0x30 );
  delay_us(10);
  lcd_char( ((data % 10) & 255) + 0x30 );
  return;
}

void lcd_put_data(char data)  // Send data via SPI to ZigBee 
{
	   Z_INT = 0; //Reset interrupt flag
       LCD_CS = 0;  // Turn chip select on
       sspbuf = data;  //place inputted data into the buffer (prepared for transmit)
       while(!Z_INT){} // Wait until transmission is complete
	   LCD_CS = 1;  //Turn chip select off
	   return;
}

void lcd_init(void)
{
	lcd_cmd(0x41);
	delay_ms(2);
	lcd_cmd(0x51);
	delay_ms(2);
	lcd_cmd(0x4C);
	delay_ms(2);
	return;
}

void lcd_clear(void)
{
	lcd_cmd(0x51);
	delay_us(15);
	return;
}
	

void lcd_cmd(char data)
{
	lcd_put_data(0xFE);
	delay_us(50);
	lcd_put_data(data);
	return;
}

void lcd_line2(void)
{
	lcd_cmd(0x46);
	lcd_cmd(0x45);
	lcd_put_data(0x40);
	return;
}

void lcd_char(char data)
{
	lcd_put_data(data);
	return;
}

void lcd_printf( const char* text )
{
  char i = 0;
  while( text[i] != 0 )
    {
    lcd_char( text[i++] );
    delay_ms(5);
    }
  return;
}

void lcd_hex(char data)
{
  char n;
  n = ((data >> 4) & 0x0F) + 0x30;
  if (n > 0x39) n = n+7;
  lcd_put_data(n);
  delay_ms(1);
  n = ((data) & 0x0F) + 0x30;
  if (n > 0x39) n = n+7;
  lcd_put_data(n);
}