/********************************************

Framework code for the Remote CPU

This code currently:

 serves as a combined header, library, and code file.

 The header and library will need to be branched off

 to separate documents at some point.

*********************************************/



/*********************************************

Notes:

  PortE reverts to a digital input on any device reset

  port numbering: 7654 3210

  set tris register HIGH (1) to make corressponding port INPUT

  LOW (0) for output

*********************************************/



#include <system.h> // necessary to use C functions
#include "AwesomeLIB.h" // necessary to use Awesome-O Functions
#include "buttons.h"

#pragma CLOCK_FREQ 4000000 // internal clock set to 4MHz by default
#pragma DATA _CONFIG1H, 0b00000010  //10 mhz
#pragma DATA _CONFIG2H, 0   // wdt off
#pragma DATA _CONFIG4L, 0b00000001  // lvp off 
#pragma DATA _CONFIG3H, 0b10000000  // mclr enabled




void init_led(void)
{
trisd.7 = 0;
trisb.3 = 0;
trisb.2 = 0;
trisb.1 = 0;
trisb.0 = 0;

trisd.5 = 0;
trisd.6 = 0;
latd.5 = 0;
latd.6 = 0;

return;
}

void display_led(char led)
{

		
		latd.7 = !((led & 0x10) >> 4);
		latb.0 = !((led & 0x08) >> 3);
		latb.1 = !((led & 0x04) >> 2);
		latb.2 = !((led & 0x02) >> 1);
		latb.3 = !(led & 0x01);
		
		

	return;
}



void main(void)
{

init_led();

char test = 0;
trisb.6=0;
trisb.7=0;

while(1)
{
test++;
latd.5=1;
latd.6=0;
if(test>125)
{test=0;
}
delay_s(1);
display_led(test);



}


return;      
}
