#include    <system.h>
#include "serial1.h"

/*
 * This is a set of serial routines which
 * deal with processors with one usart.
 *
 * made to look like serial2.c so common header file
 * is used. 
 *
 * A global variable is used to select the
 * target serial interface, and the approriate
 * routine is called base on that setting.
 *
 * 
 * */

/*
 * routine to select active usart
 * Note sure if the variable needs to
 * be static -- don't think so as it
 * is global to this file
 * */

char active_usart = 1;

void set_active_usart(char val)
{
  active_usart = 1;
  if( val == 2) active_usart = 1;
  return;
}


/*
 * Useful bit definitions (My names)
 */
 
volatile bit MT@PIR1.4;  // 1= buffer can accept
volatile bit oerr@RCSTA.1; // 1 = overrun
volatile bit DA@PIR1.5; //  1 = data available
volatile bit cren@RCSTA.4; // contin recieve. (clear oerr)
 
void serial_init(unsigned short ratescale)
{
  spbrg = 86;

  txsta = 00100100b;
  rcsta = 10010000b;
  baudcon = 0x08;  // brg16 = 1
  trisc.6 = 0;
  trisc.7 = 1;
 
}
/*
 * send a character to the terminal.
 * note this is 8-none no flow control
 * */


void putc(char value)
{
  while(!MT);    // wait for empty
  txreg = value;
}
/*
 * get a charater. no checking yet for buffer overflow
 * */

char getc(void)
{
  if(oerr)    // overrun
  {
    cren = 0;
    cren = 1;
    return 0;
  }
  while(!DA);  // wait till avail
  return rcreg;
}





/*
 * I/O routines using active usart
 */

/*
* print a string of characters to the terminal
* */

void printf(char* text)
{
	char i = 0;
	while( text[i] != 0)
	{
		putc(text[i++]);
	}
}


/********************************
* Display char in HEX - format *
********************************/
void p_hex(char data)
{
	char n;
	n = ((data >> 4) & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	n = (data & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	return;
}
/********************************
* Display  short in HEX - format *
********************************/
void p_hex(short	  data)
{
	char n;
	n = ((data >> 12) & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	n = ((data >> 8) & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	n = ((data >> 4) & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	n = (data & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	return;
}
/********************************
* Display unsigned short in HEX - format *
********************************/
void p_hex(unsigned short	  data)
{
	char n;
	n = ((data >> 12) & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	n = ((data >> 8) & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	n = ((data >> 4) & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	n = (data & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	return;
}
/********************************
* Display low nibble in HEX - format *
********************************/
void p_nib(char data)
{
	char n;
	n = (data & 0x0F) + 0x30;
	if (n > 0x39) n = n+7;
	putc(n);
	return;
}

/********************************
* Display byte in binary - format *
********************************/
void p_bin(char data)
{
	char n;
	char temp;
	temp =0x80;
	for( n=1; n<=8; ++n)
	{
		if(temp & data)
		putc(0x31);
		else
		putc(0x30);
		temp = temp >> 1;
	}
	return;
}
/********************************
* Display short in binary - format *
********************************/
void p_bin(short data)
{
	char n;
	unsigned short temp;
	temp =0x8000;
	for( n=1; n<=16; ++n)
	{
		if(temp & data)
		putc(0x31);
		else
		putc(0x30);
		temp = temp >> 1;
	}
}
/********************************
* Display unsigned short in binary - format *
********************************/
void p_bin(unsigned short data)
{
	char n;
	unsigned short temp;
	temp =0x8000;
	for( n=1; n<=16; ++n)
	{
		if(temp & data)
		putc(0x31);
		else
		putc(0x30);
		temp = temp >> 1;
	}
}

/*********************************
* Display lowest n bits of char *
********************************/
void p_bits(char data, char num_bits)
{
	char n;
	char temp;
	temp =0x80;
	for( n=8; n>=1; --n)
	{
		if(n > num_bits) temp >>=1;
		else
		{
			if(temp & data)
			putc(0x31);
			else
			putc(0x30);
			temp = temp >> 1;
		}
	}
}

void p_dec(short dat)
{
	unsigned short val;   // ascii results
	unsigned short temp;
	unsigned short div;
	unsigned short data;
	char i;
	char digit;
	data = dat;  // make it unsigned
	div = 10000;
	for(i=0; i <= 4; ++i)   // get all 5 digits
	{
		val = data/div;       // get most signif. digit
		putc(val + '0');    // print digit
		data -= val * div;   // what weve printed
		div=div/10;         // adjust divisor
	}
	return;
}

void p_dec(unsigned short dat)
{
	unsigned short val;   // ascii results
	unsigned short temp;
	unsigned short div;
	unsigned short data;
	char i;
	char digit;
	data = dat;  // make it unsigned
	div = 10000;
	for(i=0; i <= 4; ++i)   // get all 5 digits
	{
		val = data/div;       // get most signif. digit
		putc(val + '0');    // print digit
		data -= val * div;   // what weve printed
		div=div/10;         // adjust divisor
	}
	return;
}
/**********************************
* Display byte as decimal number *
**********************************/
void p_dec(char data)
{
	putc(((data /100) & 255) + 0x30);
	data = data % 100;
	putc( ((data / 10) & 255) + 0x30 );
	putc( ((data % 10) & 255) + 0x30 );
	return;
}



/*
* display char as a signed int
* */


void p_int(char data)
{
	char val;   // ascii results
	char temp;
	char div;
	char i;
	div = 100;
	/*
		* adjust for sign
		* */
	if(data & 10000000b)
	{
		putc('-');
		data = ~data + 1;
	}
	else putc(' ');
	for(i=0; i <= 2; ++i)   // get all 3 digits
	{
		val = data/div;       // get most signif. digit
		putc(val + '0');    // print digit
		data = data %div;
		div=div/10;         // adjust divisor
	}
}
/*
* display short as a signed int
* */

void p_int(short dat)
{
	short val;   // ascii results
	short temp;
	short div;
	char i;
	unsigned short data;
	bool dozero;
	dozero = true;
	data = dat;
	if((dat == 0)  && !dozero)  // always print 0
	{
		putc('0');
		return;
	}
	div = 10000;
	/*
		* adjust for sign
		* */
	if(dat < 0)
	{
		putc('-');
		data = ~data + 1;
	}
	else putc(' ');
	for(i=0; i <= 4; ++i)   // get all 3 digits
	{
		val = data/div;       // get most signif. digit
		if(val != 0 || dozero) 
		{
			putc(val + '0');    // print digit
			dozero = true;
		}
		data %= div;
		div=div/10;         // adjust divisor
	}
}
void p_int(unsigned short dat)
{
	short val;   // ascii results
	short temp;
	short div;
	char i;
	unsigned short data;
	bool dozero;
	dozero = true;
	data = dat;
	if((dat == 0)  && !dozero)  // always print 0
	{
		putc('0');
		return;
	}

	div = 10000;
	/*
		* adjust for sign
		* */
	if(dat < 0)
	{
		putc('-');
		data = ~data + 1;
	}
		else putc(' ');
	for(i=0; i <= 4; ++i)   // get all 3 digits
	{
		val = data/div;       // get most signif. digit
		if(val != 0 || dozero) 
		{
			putc(val + '0');    // print digit
			dozero = true;
		}
	data %= div;
		div=div/10;         // adjust divisor
	}
}

/*
* get a number (less than 65536) from the terminal
*/
unsigned short getnum(void)
{
	char val;
	char temp;
	char j;
	val = 0;
	j = 0;
	do
	{
		temp = getc();  // get value
		putc(temp); // echo it
		if(temp == '\r') return (val);
		val *= 10;
		val += (temp - '0');
		++j;
	} while(j <= 5);     // some error checking
	return(-1);
}
/*
* get a hex number (0 - FFFF) from the terminal
*/
unsigned short gethex(void)
{
	unsigned short val;
	char temp;
	char j;
	val = 0;
	j = 0;
	do
	{
		temp = getc();  // get value
		putc(temp); // echo it
		if(temp == '\r') return (val);
		temp -= '0';
		if(temp > 9) temp -= 7;
		if(temp > 15) temp -= 0x20;
		val <<= 4;
		val |= temp;
		++j;
	} while(j <= 4);     // some error checking
	return(-1);
}
/*
* get a character string from terminal
* with the string terminated by a carriage return
* Handles backspace to fix typos
* lenght is the number of characters entered
* not including the \0 added at the end
* prompt is expected to be external
*/
char getstring(char * string)
{
	char val;
	char temp;
	char len;
	val = 0;
	len = 0;
	// printf("\r\n String:");
	do
	{
		temp = getc();  // get value
		putc(temp); // echo it
		if(temp == '\r')
		{
			*string++ = 0;  // terminate the string
			break;
		}
		if(temp =='\b') string--;
		else
		{
			*string++ = temp;
			++len;
		}
	} while(1);     //
	return(len);
}


