/********************************************

Framework code for the Remote CPU

This code currently:

 serves as a combined header, library, and code file.

 The header and library will need to be branched off

 to separate documents at some point.

*********************************************/



/*********************************************

Notes:

  PortE reverts to a digital input on any device reset

  port numbering: 7654 3210

  set tris register HIGH (1) to make corressponding port INPUT

  LOW (0) for output

*********************************************/



#include <system.h> // necessary to use C functions
#include "AwesomeLIB.h" // necessary to use Awesome-O Functions
#include "buttons.h"

#pragma CLOCK_FREQ 4000000 // internal clock set to 4MHz by default







void main(void)

{

	trisb.1 = 0;
	trisb.3 = 0;
	char state;
    delay_ms(100);

	spi_init(); // Initialze all values for Serial Port
	transceiver_reset();  //Reset the hardware and send to state TRX_OFF
	state = trx_bit_read(SR_TRX_STATUS);

	transceiver_pll_on();  //Set to transmitter
    char sequence = 0;          //Set sequence number

        
        
	//Set up valid packet

	//FCF - Byte 1
	char frametype = 0b001; //Data
	char security = 0; //No
	security <<= 3;
	char pendingframe = 0; //No
	pendingframe <<= 4;
	char acknowledgement = 0; //No
	acknowledgement <<= 5;
	char intrapan = 0; // Yes
	intrapan <<= 6;
	//char fcf1 = 0x01;
	char fcf1 = frametype | security | pendingframe | acknowledgement | intrapan;
	
	//FCF - Byte 2
	char sourceaddressing = 0b00; // Addressing type - 16 bit short address
	sourceaddressing <<= 6;
	char frameversion = 0b00; // Compatible w/ IEEE 2003
	frameversion <<= 4;
	char destinationaddressing = 0b10;
	destinationaddressing <<= 2;
	//char fcf2 = 0x08;
	char fcf2 = sourceaddressing | frameversion | destinationaddressing;
	
	//ADDRESS BYTES
	char destpan1 = 0xCC;
	char destpan2 = 0xCC;
	char destaddress1 = 0xAA;
	char destaddress2 = 0xAA;
	//char sourceaddress1 = 0x77;
	//char sourceaddress2 = 0x77;
	
	char data1 = 0x11;
	char data2 = 0x22;
	char data3 = 0x33;
	char data4 = 0x44;
	char data5 = 0x55;
	char data6 = 0x66;
	char data7 = 0x77;
	char data8 = 0x88;
	char data9 = 0x99;
	char data10 = 0xAA;
	char data11 = 0xBB;
	char data12 = 0xCC;
        
        
        
	while(1) // TEST AREA!!!
	{		
		
		char trxarray[] = {fcf1, fcf2, sequence, destpan1, destpan2, destaddress1, destaddress2, data1, data2, data3, data4, data5, data6, data7, data8, data9, data10, data11, data12};
		char *frame;
		frame = &trxarray[0];
		
		//Ready for frame write
		TRX_PIN_SLP_TR = 1;
		delay_us(tTR10);
		delay_us(1);
		TRX_PIN_SLP_TR = 0;
		
		//Write to frame and send
		trx_frame_write(21, trxarray);
        
        //Increase sequence number
        sequence = sequence + 1;
		
		//Wait 1 second to send next one
		delay_ms(1000);


	}
	
	
return;      
}
